//=============================================================================
// MenuPetStats
//=============================================================================
class MSCMenuCCColors expands MenuUIWindow;

//var CompanionCubeHD CC;
var HouseKeeperGun _WindowOwner;
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var CCColorButton ColorSquares[3];

var ColorForwardButton ForwardButton;
var ColorBackwardButton BackwardButton;

var CCColorPicker ColorMenu;

var int XPos[3];

var CCColorButton CurColor;

var bool bSpawnedSquares;


#exec TEXTURE IMPORT NAME="CCBG256" FILE="Textures\PerkScreenBG256.pcx" GROUP=UI FLAGS=2

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------


function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 /*if (key == IK_M)
  {
   TNMDreamScapePlayer(Ralph.Owner).ShowImagesWindow();
   return true;
  }*/
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 /*if (key == IK_M)
  {
   TNMDreamScapePlayer(Ralph.Owner).ShowImagesWindow();
   return true;
  }*/
 return false;
}

function UpdateInfo()
{
	if (!root.ParentPawn.IsInState('Dying'))
	{
         if (_WindowOwner.Level.NetMode == NM_Standalone)
         {
	  ColorSquares[0].UpdateColor( ConvertSkin(_WindowOwner.GetMultiskin(0)), True );
	  ColorSquares[1].UpdateColor( ConvertSkin(_WindowOwner.GetMultiskin(1)), True );
	  ColorSquares[2].UpdateColor( ConvertSkin(_WindowOwner.GetMultiskin(3)), True );
	 }
         if (_WindowOwner.Level.NetMode != NM_Standalone)
         {
	  ColorSquares[0].UpdateColor(1);
	  ColorSquares[1].UpdateColor(2);
	  ColorSquares[2].UpdateColor(3);
	 }
	
	 /*CC.BroadcastMessage("Texture 0 = "$ConvertSkin(CC.Multiskins[0])$"!");
	 CC.BroadcastMessage("Texture 1 = "$ConvertSkin(CC.Multiskins[1])$"!");
	 CC.BroadcastMessage("Texture 3 = "$ConvertSkin(CC.Multiskins[3])$"!");*/
	 
         SetTitle("Customize Colors");
	}

	if (root.ParentPawn.IsInState('Dying')) root.PopWindow();
}

function int ConvertSkin(Texture T)
{
 //CC.BroadcastMessage("TEXTURE INPUT IS "$T$"");
 
 if (T == Texture'CCBlack') return 0;
 if (T == Texture'CCDGray') return 1;
 if (T == Texture'CCGray') return 2;
 if (T == Texture'CCWhite') return 3;
 if (T == Texture'CCRed') return 4;
 if (T == Texture'CCOrange') return 5;
 if (T == Texture'CCGold') return 6;
 if (T == Texture'CCGreen') return 7;
 if (T == Texture'CCBlue') return 8;
 if (T == Texture'CCPurple') return 9;
 
 return 0;
}

event InitWindow()
{
 local int j;
 local class<Inventory> TempItem;
 
	Super.InitWindow();
        SetTitle("Customize Colors");
        exitButton = winButtonBar.AddButton("Done", HALIGN_Left);
	
	//BuyButton = PersonaActionButtonWindow(NewChild(Class'PersonaActionButtonWindow'));
	//BuyButton.Show(False);
	//BuyButton.SetButtonText("Buy");
	
	ColorSquares[0] = CCColorButton(NewChild(Class'CCColorButton'));
	ColorSquares[0].SetPos(95, XPos[0]);
	ColorSquares[0].MS = 0;
	
	ColorSquares[1] = CCColorButton(NewChild(Class'CCColorButton'));
	ColorSquares[1].SetPos(95, XPos[1]);
	ColorSquares[1].MS = 1;
	
	ColorSquares[2] = CCColorButton(NewChild(Class'CCColorButton'));
	ColorSquares[2].SetPos(95, XPos[2]);
	ColorSquares[2].MS = 3;

	ForwardButton = ColorForwardButton(NewChild(Class'ColorForwardButton'));
	ForwardButton.SetPos(127, -32);

	BackwardButton = ColorBackwardButton(NewChild(Class'ColorBackwardButton'));
	BackwardButton.SetPos(62, -32);
	
	//ColorMenu = CCColorPicker(NewChild(Class'CCColorPicker'));
	//ColorMenu.Show(False);
	
	//AddTimer(1, True,,'UpdateInfo');
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch(buttonPressed)
	{

		case exitButton:
			root.PopWindow();
			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	if (buttonPressed.IsA('CCColorButton'))
	{
		bHandled = True;
		CurColor = CCColorButton(buttonPressed);
		
		ForwardButton.SetPos(ForwardButton.X, CurColor.Y);
		ForwardButton.CurMS = CurColor.MS;
		BackwardButton.SetPos(BackwardButton.X, CurColor.Y);
		BackwardButton.CurMS = CurColor.MS;
		
		/*CurColor.Show(False);
		ColorMenu.Show(True);
		ColorMenu.SetPos(CurColor.X + (CurColor.Width / 2) + (ColorMenu.Width / 2), CurColor.Y);
		
		ColorMenu.CurMS = CurColor.MS;
		ColorMenu.ShowButtons();
		ColorMenu.UpdateButtons();*/
	}
	if (buttonPressed.IsA('ColorForwardButton'))
	{
		_WindowOwner.ForwardMultiskin(ForwardButton.CurMS);
		UpdateInfo();
	}
	if (buttonPressed.IsA('ColorBackwardButton'))
	{
		_WindowOwner.BackwardMultiskin(BackwardButton.CurMS);
		UpdateInfo();
	}

	/*if (buttonPressed.IsA('CCColorPickerButton'))
	{
		CC.SetMultiskin(ColorMenu.CurMS, CCColorPickerButton(buttonPressed).ColRep);
		ColorMenu.HideButtons();
		ColorMenu.Show(False);	
	}*/

       /*if (exitButton != buttonPressed)
       {
	UpdateInfo();
       }*/

	return bHandled;
}

     /*clientTextures(1)=Texture'DeusExUI.UserInterface.SkillsBackground_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.SkillsBackground_3'
     clientTextures(3)=Texture'DeusExUI.UserInterface.SkillsBackground_4'
     clientTextures(4)=Texture'DeusExUI.UserInterface.SkillsBackground_5'
     clientTextures(5)=Texture'DeusExUI.UserInterface.SkillsBackground_6'

     ClientWidth=604
     ClientHeight=361*/

defaultproperties
{
     XPos(0)=25
     XPos(1)=105
     XPos(2)=185
     Title="Customize Colors"
     exitButtonText="Done"
     ClientWidth=256
     ClientHeight=256

     clientTextures(0)=Texture'CCBG256'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=3
}
